<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DriveActivity;

class ConsolidationStrategy extends \Google\Model
{
  protected $legacyType = Legacy::class;
  protected $legacyDataType = '';
  protected $noneType = NoConsolidation::class;
  protected $noneDataType = '';

  /**
   * The individual activities are consolidated using the legacy strategy.
   *
   * @param Legacy $legacy
   */
  public function setLegacy(Legacy $legacy)
  {
    $this->legacy = $legacy;
  }
  /**
   * @return Legacy
   */
  public function getLegacy()
  {
    return $this->legacy;
  }
  /**
   * The individual activities are not consolidated.
   *
   * @param NoConsolidation $none
   */
  public function setNone(NoConsolidation $none)
  {
    $this->none = $none;
  }
  /**
   * @return NoConsolidation
   */
  public function getNone()
  {
    return $this->none;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ConsolidationStrategy::class, 'Google_Service_DriveActivity_ConsolidationStrategy');
